﻿using System;
using System.Text;

namespace gov.va.med.VBECS.Communication.Common
{
    [Serializable]
    public class TextMessage : BaseMessage
    {
        public string Text { get; set; }

        public TextMessage()
        {
        }

        public TextMessage(byte[] theBytes)
        {
            Text = Encoding.UTF8.GetString(theBytes);
        }

        public TextMessage(string theData)
        {
            Text = theData;
        }
        public TextMessage(string theRepliedId, string theText)
            : base(theRepliedId)
        {
            Text = theText;
        }

        public override byte[] GetBytes()
        {
            return Encoding.UTF8.GetBytes(Text);
        }
    }
}
